# -*- coding: utf-8 -*-
from odoo import models, fields

class ResConfigSettings(models.TransientModel):
    _inherit = 'res.config.settings'

    stock_card_low_threshold = fields.Float(
        string='Low Stock Threshold',
        config_parameter='sss_stock_card_report.low_stock_threshold',
        default=100.0,
        help='Balance below this value will be considered as Low Stock'
    )
    
    stock_card_normal_threshold = fields.Float(
        string='Normal Stock Threshold',
        config_parameter='sss_stock_card_report.normal_stock_threshold',
        default=500.0,
        help='Balance between Low Stock and this value will be considered as Normal'
    ) 