# -*- coding: utf-8 -*-
from odoo import models, api
from odoo.exceptions import ValidationError
from odoo.tools.translate import _







from datetime import datetime















class StockCardReport(models.AbstractModel):







    _name = 'report.sss_stock_card_report.stock_card_report'







    _description = 'Stock Card Report'















    def _get_stock_moves(self, product, date_from, date_to, warehouse):







        domain = [







            ('product_id', '=', product.id),







            ('state', '=', 'done'),







            ('date', '>=', date_from),







            ('date', '<=', date_to),







            '|',







                ('location_id.warehouse_id', '=', warehouse.id),







                ('location_dest_id.warehouse_id', '=', warehouse.id)







        ]







        moves = self.env['stock.move'].search(domain, order='date')







        return moves















    def _get_opening_balance(self, product, start_date, warehouse):







        domain = [







            ('product_id', '=', product.id),







            ('state', '=', 'done'),







            ('date', '<', start_date),







            '|',







                ('location_id.warehouse_id', '=', warehouse.id),







                ('location_dest_id.warehouse_id', '=', warehouse.id)







        ]







        







        opening_moves = self.env['stock.move'].search(domain)







        balance = 0.0







        







        for move in opening_moves:







            if move.location_dest_id.warehouse_id.id == warehouse.id:







                balance += move.product_qty







            if move.location_id.warehouse_id.id == warehouse.id:







                balance -= move.product_qty







                







        return balance















    def _get_stock_status(self, balance, product):







        """







        Determine stock status based on balance and product thresholds







        Returns: tuple(status_code, status_text)







        status_code: 'low', 'normal', or 'high'







        """







        low_threshold = product.stock_card_low_threshold







        normal_threshold = product.stock_card_normal_threshold







        if balance < low_threshold:







            return 'low', _('Low Stock')







        elif balance < normal_threshold:







            return 'normal', _('Normal')







        else:







            return 'high', _('High Stock')















    def _get_report_data(self, wizard):
        # Ensure wizard is a single record
        if hasattr(wizard, 'ensure_one'):
            wizard.ensure_one()
        elif len(wizard) > 1:
            wizard = wizard[0]







        if wizard.report_by == 'product':







            if not wizard.product_ids:







                raise ValidationError(_('Please select at least one product.'))







            products = wizard.product_ids







        else:







            if not wizard.category_ids:







                raise ValidationError(_('Please select at least one product category.'))







            # Get all category IDs including child categories
            all_category_ids = list(wizard.category_ids.ids)
            for category in wizard.category_ids:
                # Include child categories recursively using child_of operator
                child_categories = self.env['product.category'].search([
                    ('id', 'child_of', category.id)
                ])
                all_category_ids.extend(child_categories.ids)
            # Remove duplicates
            all_category_ids = list(set(all_category_ids))

            # Search for products in selected categories
            # In Odoo 18, products with type='consu' (Goods) are Storable Products
            # Domain: product must be type='consu' AND (in category OR template in category)
            products = self.env['product.product'].search([







                ('type', '=', 'consu'),
                '|',
                ('categ_id', 'in', all_category_ids),
                ('product_tmpl_id.categ_id', 'in', all_category_ids),














            ])







            if not products:







                raise ValidationError(_('No products found in the selected categories.'))







        result = []







        for product in products:







            moves = self._get_stock_moves(product, wizard.start_date, wizard.end_date, wizard.warehouse_id)







            balance = self._get_opening_balance(product, wizard.start_date, wizard.warehouse_id)







            move_lines = []







            







            # Add opening balance line







            move_lines.append({







                'date': wizard.start_date,







                'origin': 'Opening Balance',







                'picking_number': False,







                'quantity_in': 0,







                'quantity_out': 0,







                'balance': balance,







            })















            for move in moves:







                qty_in = qty_out = 0







                if move.location_dest_id.warehouse_id.id == wizard.warehouse_id.id:







                    qty_in = move.product_qty







                    balance += move.product_qty







                if move.location_id.warehouse_id.id == wizard.warehouse_id.id:







                    qty_out = move.product_qty







                    balance -= move.product_qty















                # Get picking number and origin







                picking_number = move.picking_id.name if move.picking_id else ''







                origin = move.picking_id.origin or ''







                display_name = picking_number







                if origin and origin != picking_number:







                    display_name = f"{picking_number} ({origin})" if picking_number else origin







                move_lines.append({







                    'date': move.date,







                    'origin': display_name or move.name,







                    'picking_number': picking_number,







                    'quantity_in': qty_in,







                    'quantity_out': qty_out,







                    'balance': balance,







                })















            # Ensure move_lines is never empty (should always have opening balance)
            if not move_lines:
                move_lines.append({
                    'date': wizard.start_date,
                    'origin': 'Opening Balance',
                    'picking_number': False,
                    'quantity_in': 0,
                    'quantity_out': 0,
                    'balance': balance,
                })
            
            current_balance = move_lines[-1]['balance'] if move_lines else balance







            status_code, status_text = self._get_stock_status(current_balance, product)







            result.append({







                'product': product,







                'moves': move_lines,







                'stock_status': {







                    'code': status_code,







                    'text': status_text,







                    'balance': current_balance







                }







            })















        return result















    @api.model







    def _get_report_values(self, docids, data=None):







        if not docids:







            raise ValidationError(_('No report data found.'))







        # Ensure docids is a list
        if not isinstance(docids, (list, tuple)):
            docids = [docids]
        
        if not docids or not docids[0]:
            raise ValidationError(_('No report data found.'))
        
        wizard = self.env['stock.card.wizard'].browse(docids[0])
        wizard.ensure_one()







        if not wizard.exists():







            raise ValidationError(_('Report wizard not found.'))







        return {







            'doc_ids': docids,







            'doc_model': 'stock.card.wizard',







            'docs': wizard,







            'data': [pd for pd in (self._get_report_data(wizard) or []) if pd.get('product')],







        }






