# Asset Cancellation Module (Odoo 19)

<div align="center">

**إلغاء الأصول مع عكس القيود تلقائياً في Odoo 19**

[![License](https://img.shields.io/badge/license-LGPL--3-blue.svg)](LICENSE)
[![Version](https://img.shields.io/badge/version-19.0.1.0.0-green.svg)](__manifest__.py)
[![Odoo](https://img.shields.io/badge/odoo-19.0-blue.svg)](https://www.odoo.com)

</div>

---

## 📋 نظرة عامة | Overview

موديول **إلغاء الأصول** يضيف ميزة قوية لإدارة الأصول في Odoo. يتيح لك إلغاء الأصول التي تم إنشاؤها بالخطأ مع عكس جميع القيود المحاسبية المرتبطة بها تلقائياً. يحتفظ الموديول بسجل كامل عن سبب الإلغاء والمسؤول عنه وتاريخ الإلغاء.

The **Asset Cancellation** module adds powerful asset management capabilities to Odoo. It allows you to cancel assets that were created by mistake with automatic reversal of all associated accounting entries. The module maintains a complete audit trail of cancellation reasons, responsible users, and cancellation dates.

---

## ✨ المميزات الرئيسية | Key Features

### 🔄 إلغاء الأصول التلقائي | Automatic Asset Cancellation
- **إلغاء بنقرة واحدة**: إلغاء الأصول التي تم إنشاؤها بالخطأ بسهولة
- **عكس القيود تلقائياً**: يتم عكس جميع قيود الإهلاك المرسلة تلقائياً
- **حذف القيود المسودة**: يتم حذف جميع القيود في حالة المسودة تلقائياً
- **تتبع كامل**: حفظ سبب الإلغاء والمسؤول عنه وتاريخ الإلغاء

- **One-Click Cancellation**: Easily cancel assets that were created by mistake
- **Automatic Reversal**: All posted depreciation entries are automatically reversed
- **Draft Cleanup**: All draft entries are automatically deleted
- **Full Audit Trail**: Tracks cancellation reason, responsible user, and cancellation date

### 📊 تتبع المعلومات | Information Tracking
- **سبب الإلغاء**: حقل نصي لتسجيل سبب إلغاء الأصل
- **المسؤول عن الإلغاء**: تتبع المستخدم الذي قام بالإلغاء
- **تاريخ الإلغاء**: تسجيل تاريخ الإلغاء تلقائياً
- **تتبع التغييرات**: جميع الحقول قابلة للتتبع في Chatter

- **Cancellation Reason**: Text field to record why the asset was cancelled
- **Cancelled By**: Tracks the user who performed the cancellation
- **Cancellation Date**: Automatically records the cancellation date
- **Change Tracking**: All fields are tracked in the Chatter

### 🎯 واجهة المستخدم | User Interface
- **زر "Wrong Asset"**: زر واضح في نموذج الأصل لإلغاء الأصل
- **معلومات الإلغاء**: قسم مخصص لعرض معلومات الإلغاء عند الحاجة
- **Statusbar**: إضافة حالة "Cancelled" إلى شريط الحالة
- **اختصار لوحة المفاتيح**: Shift+C لإلغاء الأصل بسرعة

- **"Wrong Asset" Button**: Clear button in asset form to cancel the asset
- **Cancellation Info**: Dedicated section to display cancellation information when needed
- **Statusbar**: Adds "Cancelled" state to the status bar
- **Keyboard Shortcut**: Shift+C to quickly cancel the asset

### 🔒 الأمان والتحكم | Security & Control
- **مجموعة الأمان**: مجموعة مخصصة للتحكم في من يمكنه إلغاء الأصول
- **التحقق من الحالة**: يمكن إلغاء الأصول فقط في حالة "Running" أو "Paused"
- **رسائل خطأ واضحة**: رسائل خطأ واضحة عند محاولة إلغاء أصل غير مناسب

- **Security Group**: Dedicated group to control who can cancel assets
- **State Validation**: Only assets in "Running" or "Paused" state can be cancelled
- **Clear Error Messages**: Clear error messages when trying to cancel inappropriate assets

---

## 🚀 التثبيت | Installation

### المتطلبات | Prerequisites
- Odoo 19.0 أو أحدث
- موديول `account_asset` مثبت ومفعّل

- Odoo 19.0 or later
- `account_asset` module installed and enabled

### خطوات التثبيت | Installation Steps

1. **انسخ الموديول** إلى مجلد الإضافات:
   ```bash
   cp -r sss_asset_cancellation /path/to/odoo/addons/
   ```

2. **حدّث قائمة التطبيقات** في Odoo:
   - اذهب إلى قائمة **Apps**
   - اضغط **Update Apps List**

3. **ثبّت الموديول**:
   - ابحث عن "Asset Cancellation"
   - اضغط **Install**

---

## 📖 دليل الاستخدام | Usage Guide

### سيناريو أساسي | Basic Scenario

#### إلغاء أصل تم إنشاؤه بالخطأ | Cancelling a Mistakenly Created Asset

**الخطوات | Steps:**

1. **افتح الأصل** الذي تريد إلغاءه
   - تأكد أن الأصل في حالة "Running" أو "Paused"

2. **اضغط زر "Wrong Asset"**
   - سيظهر معالج الإلغاء

3. **أدخل سبب الإلغاء**
   - مثال: "تم إنشاء الأصل بالخطأ - رقم الأصل الصحيح هو XYZ123"

4. **اضغط "Confirm"**
   - سيتم:
     - عكس جميع قيود الإهلاك المرسلة
     - حذف جميع القيود في حالة المسودة
     - تحديث حالة الأصل إلى "Cancelled"
     - حفظ سبب الإلغاء والمسؤول عنه وتاريخ الإلغاء
     - إضافة رسالة في Chatter

### حالات الاستخدام | Use Cases

#### حالة 1: أصل تم إنشاؤه بالخطأ
- **المشكلة**: تم إنشاء أصل بنوع خاطئ أو معلومات خاطئة
- **الحل**: استخدم الموديول لإلغاء الأصل وإنشاء الأصل الصحيح

#### حالة 2: أصل لم يعد مطلوباً
- **المشكلة**: أصل تم شراؤه ولكن لم يتم استخدامه
- **الحل**: ألغِ الأصل مع توثيق السبب

#### حالة 3: تصحيح أخطاء محاسبية
- **المشكلة**: أصول تم تسجيلها بالخطأ في الفترة المالية
- **الحل**: ألغِ الأصول مع عكس جميع القيود المرتبطة

---

## 🛠️ التفاصيل التقنية | Technical Details

### هيكل الموديول | Module Structure

```
sss_asset_cancellation/
├── models/
│   └── account_asset.py          # نموذج الأصل مع وظائف الإلغاء
├── wizards/
│   └── asset_cancellation_wizard.py  # معالج إلغاء الأصل
├── views/
│   └── account_asset_views.xml   # واجهات المستخدم
├── security/
│   ├── security.xml               # مجموعات الأمان
│   └── ir.model.access.xml       # حقوق الوصول
└── static/
    └── description/
        └── icon.png
```

### التوسعات على النموذج | Model Extensions

#### `account.asset` (Extended)

**حقول جديدة | New Fields:**
- `state`: إضافة حالة "cancelled"
- `cancellation_reason`: سبب الإلغاء (نص)
- `cancelled_by`: المستخدم الذي قام بالإلغاء
- `cancellation_date`: تاريخ الإلغاء

**وظائف جديدة | New Methods:**
- `action_cancel_asset(reason)`: إلغاء الأصل مع السبب
- `_set_cancelled_state(reason)`: تعيين حالة الإلغاء مع المعلومات
- `toggle_active()`: تعديل للسماح بأرشفة الأصول الملغاة

**المنطق | Logic:**
- يبحث عن جميع قيود الإهلاك المرسلة
- ينشئ قيود عكس لكل قيد مرسل
- يحذف جميع القيود في حالة المسودة
- يحفظ معلومات الإلغاء
- يضيف رسالة في Chatter

### معالج الإلغاء | Cancellation Wizard

#### `asset.cancellation.wizard`

**الحقول | Fields:**
- `reason`: سبب الإلغاء (مطلوب)
- `asset_id`: الأصل المراد إلغاؤه
- `state`: حالة الأصل (للقراءة فقط)

**الوظائف | Methods:**
- `action_confirm()`: تأكيد الإلغاء
- `_onchange_asset_id()`: التحقق من حالة الأصل

---

## 🔍 استكشاف الأخطاء | Troubleshooting

### المشكلة: لا يمكن إلغاء الأصل
**الأسباب المحتملة | Possible Causes:**
- الأصل ليس في حالة "Running" أو "Paused"
- المستخدم ليس لديه صلاحيات الإلغاء
- الأصل ملغى بالفعل

**الحلول | Solutions:**
1. تحقق من حالة الأصل
2. تأكد من أن المستخدم عضو في مجموعة "Asset Cancellation"
3. تحقق من أن الأصل لم يتم إلغاؤه مسبقاً

### المشكلة: القيود لم يتم عكسها
**الأسباب المحتملة | Possible Causes:**
- القيود لم تكن في حالة "Posted"
- خطأ في عملية العكس

**الحلول | Solutions:**
1. تحقق من حالة القيود قبل الإلغاء
2. راجع سجلات Odoo للأخطاء
3. اتصل بالدعم الفني إذا استمرت المشكلة

---

## 📊 أفضل الممارسات | Best Practices

### 1. توثيق أسباب الإلغاء
- استخدم أسباب واضحة ومفصلة
- اذكر رقم الأصل الصحيح إذا كان هناك بديل
- اذكر التاريخ والفترة المالية إذا كان ذلك مهماً

### 2. مراجعة قبل الإلغاء
- تأكد من أن الأصل يجب إلغاؤه
- راجع جميع القيود المرتبطة
- تأكد من عدم وجود اعتماديات أخرى

### 3. الأمان
- حدد مجموعة صغيرة من المستخدمين المسموح لهم بالإلغاء
- راجع سجلات الإلغاء بانتظام
- احتفظ بسجلات منفصلة للأصول الملغاة

---

## 🔄 تاريخ الإصدارات | Version History

### Version 19.0.1.0.0
- الإصدار الأولي لـ Odoo 19
- إلغاء الأصول مع عكس القيود
- تتبع معلومات الإلغاء
- واجهة مستخدم محسّنة
- مجموعات أمان مخصصة

---

## 📞 الدعم والاتصال | Support & Contact

### الحصول على المساعدة | Get Help

- **الموقع الإلكتروني**: [https://solidsups.com](https://solidsups.com)
- **البريد الإلكتروني**: info@solidsups.com
- **LinkedIn**: [Solid Super Solutions](https://www.linkedin.com/company/109981576)

### الإبلاغ عن الأخطاء | Bug Reports

يرجى الإبلاغ عن الأخطاء أو طلبات الميزات من خلال:
- البريد الإلكتروني: info@solidsups.com
- يرجى تضمين إصدار الموديول وإصدار Odoo في تقريرك

---

## 📄 الترخيص | License

هذا الموديول مرخص تحت **LGPL-3**.

This module is licensed under **LGPL-3**.

---

<div align="center">

**تم التطوير بواسطة [Solid Super Solutions](https://solidsups.com)**

**Developed with ❤️ by [Solid Super Solutions](https://solidsups.com)**

*تحسين إدارة الأصول في Odoo*

*Enhancing asset management in Odoo*

</div>
