# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import models, fields, api, _
from odoo.exceptions import UserError


class AssetCancellationWizard(models.TransientModel):
    _name = 'asset.cancellation.wizard'
    _description = 'Asset Cancellation Wizard'

    reason = fields.Text(string='Cancellation Reason', required=True)
    asset_id = fields.Many2one('account.asset', string='Asset', required=True,
                              default=lambda self: self.env.context.get('active_id'))
    state = fields.Selection(related='asset_id.state', readonly=True)

    @api.onchange('asset_id')
    def _onchange_asset_id(self):
        if self.asset_id and self.asset_id.state not in ['open', 'paused']:
            raise UserError(_('Only running or paused assets can be cancelled.'))

    def action_confirm(self):
        """Confirm the asset cancellation with reason."""
        self.ensure_one()
        if not self.asset_id:
            raise UserError(_('No asset selected.'))

        if self.asset_id.state == 'cancelled':
            raise UserError(_('Asset is already cancelled.'))
        
        if self.asset_id.state not in ['open', 'paused']:
            raise UserError(_('Only running or paused assets can be cancelled.'))

        return self.asset_id.action_cancel_asset(reason=self.reason) 