# Contact Approval (Odoo 17)

Manage contacts through the Approval Manager's validation process.

## Features
- Approve or cancel contacts through Contacts Approval Manager
- Only approved contacts can be used in sales, purchasing, inventory, and invoice models
- Contact status tracking (Draft, Approved, Cancelled)
- Prevents using unapproved contacts in transactions
- Approval workflow with statusbar

## Usage
1. Go to Contacts → Contacts
2. Create or open a contact
3. Use header buttons to:
   - Approve: Change status to Approved
   - Cancel: Change status to Cancelled
   - Reset: Change status back to Draft
4. Only approved contacts can be selected in:
   - Sales Orders
   - Purchase Orders
   - Stock Pickings
   - Invoices/Bills
   - CRM Leads

## Security
- Requires "Contacts Approval Manager" group permission
- Only group members can approve/cancel/reset contacts

## Compatibility
- Tested on Odoo 17.0
- Requires `contacts`, `sale_management`, `purchase`, `stock`, `account` modules

## Support
- Website: https://solidsups.com
- Email: info@solidsups.com

