from odoo import models, api

class AccountMove(models.Model):
    _inherit = 'account.move'

    def print_journal_report(self):
        return self.env.ref('sss_simple_journal_report.action_simple_journal_report').report_action(self)

class AccountMoveLine(models.Model):
    _inherit = 'account.move.line'

    def get_formatted_analytic_distribution(self):
        self.ensure_one()
        if not self.analytic_distribution:
            return ''
        
        formatted_dist = []
        analytic_accounts = self.env['account.analytic.account'].browse(
            [int(x) for x in self.analytic_distribution.keys()]
        )
        account_dict = {str(acc.id): acc.name for acc in analytic_accounts}
        
        for account_id, percentage in self.analytic_distribution.items():
            name = account_dict.get(account_id, '')
            if name:
                formatted_dist.append(f"{name}: {percentage}%")
                
        return "\n".join(formatted_dist) 