# All Copyrights Reserved to Solid Super Solutions

{
    'name': 'Simple Journal Entry Report',
    'version': '18.0.1.0.0',
    'category': 'Accounting/Accounting',
    'summary': 'Custom Journal Entry Report with Company Details',
    'description': """
        This module adds a simple journal entry report feature to the accounting module:
        * Company Logo and Information
        * Custom Header and Footer
        * Detailed Journal Entries with Analytics
        * Multi-currency Support
        * Bilingual Support (English/Arabic)

Developed by Solid Super Solutions
Website: https://solidsups.com
LinkedIn: https://www.linkedin.com/company/109981576
    """,
    'author': 'Solid Super Solutions',
    'website': 'https://solidsups.com',
    'support': 'info@solidsups.com',
    'maintainer': 'Solid Super Solutions',
    'depends': [
        'base',
        'account',
        'web',
        'analytic',
    ],
    'data': [
        'security/ir.model.access.csv',
        'views/report_settings_views.xml',
        'views/account_move_views.xml',
        'reports/journal_report.xml',
    ],
    'images': ['static/description/icon.png'],
    'icon': 'sss_simple_journal_report/static/description/icon.png',
    'assets': {
        'web.report_assets_common': [
            'sss_simple_journal_report/static/src/fonts/IBMPlexSansArabic-Regular.ttf',
            'sss_simple_journal_report/static/src/scss/style.scss',
        ],
    },
    'license': 'LGPL-3',
    'installable': True,
    'application': False,
    'auto_install': False,
    'translation': ['i18n/ar_001.po'],
} 